/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.menu;

import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.menu.slot.BackpackSlot;
import info.u_team.useful_backpacks.type.BackpackType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackMenu
extends UContainerMenu {
    private final Container backpackInventory;
    private final BackpackType backpack;
    private final int selectedSlot;

    public static BackpackMenu createClientContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        BackpackType backpack = (BackpackType)buffer.m_130066_(BackpackType.class);
        int selectedSlot = buffer.m_130242_();
        return new BackpackMenu(id, playerInventory, (Container)new SimpleContainer(backpack.getInventorySize()), backpack, selectedSlot);
    }

    public BackpackMenu(int id, Inventory playerInventory, Container backpackInventory, BackpackType backpack, int selectedSlot) {
        super((MenuType)UsefulBackpacksMenuTypes.BACKPACK.get(), id);
        this.backpackInventory = backpackInventory;
        this.backpack = backpack;
        this.selectedSlot = selectedSlot;
        this.addBackpackInventory(backpack.getSlotBackpackX(), backpack.getSlotBackpackY());
        this.addPlayerInventory(playerInventory, backpack.getSlotPlayerX(), backpack.getSlotPlayerY());
    }

    public void addBackpackInventory(int x, int y) {
        for (int height = 0; height < this.backpack.getInventoryHeight(); ++height) {
            for (int width = 0; width < this.backpack.getInventoryWidth(); ++width) {
                this.m_38897_(new BackpackSlot(this.backpackInventory, width + height * this.backpack.getInventoryWidth(), width * 18 + x, height * 18 + y));
            }
        }
    }

    public void m_38946_() {
        super.m_38946_();
        Container container = this.backpackInventory;
        if (container instanceof BackpackInventory) {
            BackpackInventory inventory = (BackpackInventory)container;
            inventory.writeItemStack();
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.backpack.getInventorySize() ? !this.m_38903_(itemstack1, this.backpack.getInventorySize(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.backpack.getInventorySize(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        Slot tmpSlot = slotId >= 0 && slotId < this.f_38839_.size() ? (Slot)this.f_38839_.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.f_40218_ == player.m_150109_() && tmpSlot.m_150661_() == this.selectedSlot) {
            return;
        }
        if (clickType == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.m_150109_().m_8020_(dragType);
            ItemStack itemStack = Inventory.m_36045_((int)this.selectedSlot) ? (ItemStack)player.m_150109_().f_35974_.get(this.selectedSlot) : (currentItem = this.selectedSlot == -1 ? (ItemStack)player.m_150109_().f_35976_.get(0) : ItemStack.f_41583_);
            if (!currentItem.m_41619_() && stack == currentItem) {
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public boolean m_6875_(Player player) {
        Container container = this.backpackInventory;
        if (container instanceof BackpackInventory) {
            BackpackInventory inventory = (BackpackInventory)container;
            ItemStack stack = inventory.getStack();
            return !stack.m_41619_() && stack.m_41720_() instanceof Backpack;
        }
        return true;
    }

    public BackpackType getBackpack() {
        return this.backpack;
    }

    public Container getBackpackInventory() {
        return this.backpackInventory;
    }
}

